/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWCompoundStepDefinition;
import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWMLABase;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWReceiveInstruction;
import filenet.vw.api.VWReplyInstruction;
import filenet.vw.api.VWSession;
import filenet.vw.api.VWValidationContext;
import filenet.vw.api.VWValidationError;
import filenet.vw.api.VWWorkflowSignature;
import filenet.vw.api.VWXMLHandler;
import filenet.vw.api.VWXMLSchemaSubType;
import filenet.vw.base.VWString;
import filenet.vw.base.exprcomp.VWCompiledExpr;
import filenet.vw.base.exprcomp.VWCompiledRefExpr;
import filenet.vw.base.exprcomp.VWExpr;
import java.io.Serializable;
import java.util.Vector;

public final class VWWebServiceParameterDefinition
extends VWMLABase
implements Serializable {
    private static final long serialVersionUID = 7449L;
    private String m_Name = null;
    private int m_Mode = -1;
    private int m_DataType = -1;
    private boolean m_bIsArray = false;
    private String m_Value = null;
    private String m_NameSpace = null;
    private String m_Attributes = null;
    private String m_ArrayTag = null;
    private String m_ArrayNameSpace = null;
    private String m_ArrayAttributes = null;
    private int m_LexicalLevel = -1;
    private boolean m_bAttachmentByValue = false;
    private int m_SchemaSubType = -1;
    protected int m_Sequence = -1;
    protected VWInstructionDefinition m_MyInstruction = null;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-06-19 01:22:35 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Darik Siegfried;5D6048897;dsiegfried@us.ibm.com (dsiegfried) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_451_Int/PUI_452_Int/PUI_460_Int/6 $";
    }

    VWWebServiceParameterDefinition() {
    }

    protected VWWebServiceParameterDefinition(VWInstructionDefinition theContainingInstruction, String theName, int theMode, int theType, boolean theIsArray, String theValue) throws VWException {
        this.m_MyInstruction = theContainingInstruction;
        this.setName(theName);
        this.setMode(theMode);
        this.setDataType(theType);
        this.setValue(theValue);
        this.m_bIsArray = theIsArray;
    }

    public void setIsArray(boolean theIsArray) throws VWException {
        this.m_bIsArray = theIsArray;
    }

    public boolean getIsArray() {
        return this.m_bIsArray;
    }

    public void setName(String theName) throws VWException {
        if (theName == null || theName.length() == 0) {
            throw new VWException("vw.api.VWWebServiceParameterDefinitionDefinitionBadName", "Parameter name cannot be null");
        }
        this.m_Name = theName;
    }

    public String getName() {
        return this.translateStr(this.m_Name);
    }

    public void setValue(String theValue) throws VWException {
        this.m_Value = theValue != null ? theValue.trim() : null;
    }

    public String getValue() {
        return this.m_Value;
    }

    public void setDataType(int theDataType) throws VWException {
        if (!VWFieldType.isValid(theDataType)) {
            throw new VWException("vw.api.VWWebServicesParameterDefinitionInvalidFieldType", "theDataType is invalid.");
        }
        this.m_DataType = theDataType;
    }

    public int getDataType() {
        return this.m_DataType;
    }

    protected void setMode(int theMode) throws VWException {
        if (!VWModeType.isValid(theMode)) {
            throw new VWException("vw.api.VWWebServiceParameterDefinitionInvalidModeType", "theModeType is not a valid mode type");
        }
        this.m_Mode = theMode;
    }

    public int getMode() {
        return this.m_Mode;
    }

    public void setAttachmentByValue(boolean setting) throws VWException {
        this.m_bAttachmentByValue = setting;
    }

    public boolean isAttachmentByValue() throws VWException {
        return this.m_bAttachmentByValue;
    }

    public void setNameSpace(String nameSpace) throws VWException {
        this.m_NameSpace = nameSpace;
    }

    public String getNameSpace() throws VWException {
        this.correctNameSpaceForAttachmentByRef();
        return this.m_NameSpace;
    }

    public void setAttributes(String attributes) throws VWException {
        this.m_Attributes = attributes;
    }

    public String getAttributes() throws VWException {
        return this.m_Attributes;
    }

    public void setArrayTag(String arrayTag) throws VWException {
        this.m_ArrayTag = arrayTag;
    }

    public String getArrayTag() throws VWException {
        return this.m_ArrayTag;
    }

    public void setArrayNameSpace(String arrayNameSpace) throws VWException {
        this.m_ArrayNameSpace = arrayNameSpace;
    }

    public String getArrayNameSpace() throws VWException {
        return this.m_ArrayNameSpace;
    }

    public void setArrayAttributes(String arrayAttributes) throws VWException {
        this.m_ArrayAttributes = arrayAttributes;
    }

    public String getArrayAttributes() throws VWException {
        return this.m_ArrayAttributes;
    }

    public void setSequenceNumber(int seq) throws VWException {
        this.m_Sequence = seq;
    }

    public int getSequenceNumber() throws VWException {
        return this.m_Sequence;
    }

    public void setLexicalLevel(int level) throws VWException {
        this.m_LexicalLevel = level;
    }

    public int getLexicalLevel() throws VWException {
        return this.m_LexicalLevel;
    }

    public void setSchemaSubType(int schemaSubType) throws VWException {
        if (!VWXMLSchemaSubType.isValid(schemaSubType)) {
            throw new VWException("vw.api.VWWebServiceParameterDefinitionInvalidSchemaSubType", "schemaSubType is not a valid schema sub type");
        }
        this.m_SchemaSubType = schemaSubType;
    }

    public int getSchemaSubType() throws VWException {
        return this.m_SchemaSubType;
    }

    public String toString() {
        return this.getName();
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWebServiceParameterDefinitionNullBuffer", "buffer parameter cannot be null.");
        }
        String INDENT_0 = "";
        String INDENT_1 = INDENT_0 + "\t";
        theBuffer.append(INDENT_0 + "<" + "WSParameter" + "\n");
        theBuffer.append(INDENT_1 + "Name" + "=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\"\n");
        if (this.m_Value != null) {
            theBuffer.append(INDENT_1 + "ValueExpr" + "=\"" + VWXMLHandler.toXMLString(this.m_Value) + "\"\n");
        }
        theBuffer.append(INDENT_1 + "Type" + "=\"" + VWFieldType.typeToString(this.m_DataType) + "\"\n");
        theBuffer.append(INDENT_1 + "IsArray" + "=\"" + this.m_bIsArray + "\"\n");
        theBuffer.append(INDENT_1 + "Mode" + "=\"" + VWModeType.typeToString(this.m_Mode) + "\"");
        this.correctNameSpaceForAttachmentByRef();
        if (this.m_NameSpace != null) {
            theBuffer.append("\n" + INDENT_1 + "NameSpace" + "=\"" + VWXMLHandler.toXMLString(this.m_NameSpace) + "\"");
        }
        if (this.m_Attributes != null) {
            theBuffer.append("\n" + INDENT_1 + "Attributes" + "=\"" + VWXMLHandler.toXMLString(this.m_Attributes) + "\"");
        }
        if (this.m_ArrayTag != null) {
            theBuffer.append("\n" + INDENT_1 + "ArrayTag" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayTag) + "\"");
        }
        if (this.m_ArrayNameSpace != null) {
            theBuffer.append("\n" + INDENT_1 + "ArrayNameSpace" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayNameSpace) + "\"");
        }
        if (this.m_ArrayAttributes != null) {
            theBuffer.append("\n" + INDENT_1 + "ArrayAttributes" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayAttributes) + "\"");
        }
        if (this.m_LexicalLevel != -1) {
            theBuffer.append("\n" + INDENT_1 + "LexicalLevel=\"" + Integer.toString(this.m_LexicalLevel) + "\"");
        }
        if (this.m_bAttachmentByValue) {
            theBuffer.append("\n" + INDENT_1 + "AttachmentByValue=\"true\"");
        }
        if (this.m_Sequence != -1) {
            theBuffer.append("\n" + INDENT_1 + "Sequence=\"" + Integer.toString(this.m_Sequence) + "\"");
        }
        if (this.m_SchemaSubType != -1) {
            theBuffer.append("\n" + INDENT_1 + "SchemaSubType=\"" + VWXMLSchemaSubType.typeToString(this.m_SchemaSubType) + "\"");
        }
        theBuffer.append("/>\n");
    }

    private void correctNameSpaceForAttachmentByRef() {
        if (this.m_DataType != 32 || this.m_bAttachmentByValue) {
            return;
        }
        this.m_NameSpace = null;
    }

    public void toXPDL(String indentA, StringBuffer theBuffer) throws VWException {
        String indentB = VWXMLHandler.incXMLIndent(indentA);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWebServiceParameterDefinitionXPDLNullBuffer", "toXPDL buffer parameter cannot be null.");
        }
        theBuffer.append(indentA + "<fn:ActualParameter fn:Name=\"" + VWXMLHandler.toXMLString(this.m_Name) + "\" fn:Type=\"" + VWFieldType.typeToString(this.m_DataType) + "\" fn:IsArray=\"" + this.m_bIsArray + "\" fn:Mode=\"" + VWModeType.typeToString(this.m_Mode) + "\"");
        this.correctNameSpaceForAttachmentByRef();
        if (this.m_NameSpace != null) {
            theBuffer.append("\n" + indentB + "fn:NameSpace" + "=\"" + VWXMLHandler.toXMLString(this.m_NameSpace) + "\"");
        }
        if (this.m_Attributes != null) {
            theBuffer.append("\n" + indentB + "fn:Attributes" + "=\"" + VWXMLHandler.toXMLString(this.m_Attributes) + "\"");
        }
        if (this.m_ArrayTag != null) {
            theBuffer.append("\n" + indentB + "fn:ArrayTag" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayTag) + "\"");
        }
        if (this.m_ArrayNameSpace != null) {
            theBuffer.append("\n" + indentB + "fn:ArrayNameSpace" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayNameSpace) + "\"");
        }
        if (this.m_ArrayAttributes != null) {
            theBuffer.append("\n" + indentB + "fn:ArrayAttributes" + "=\"" + VWXMLHandler.toXMLString(this.m_ArrayAttributes) + "\"");
        }
        if (this.m_LexicalLevel != -1) {
            theBuffer.append("\n" + indentB + "fn:LexicalLevel=\"" + Integer.toString(this.m_LexicalLevel) + "\"");
        }
        if (this.m_bAttachmentByValue) {
            theBuffer.append("\n" + indentB + "fn:AttachmentByValue=\"true\"");
        }
        if (this.m_Sequence != -1) {
            theBuffer.append("\n" + indentB + "fn:Sequence=\"" + Integer.toString(this.m_Sequence) + "\"");
        }
        if (this.m_SchemaSubType != -1) {
            theBuffer.append("\n" + indentB + "fn:SchemaSubType=\"" + VWXMLSchemaSubType.typeToString(this.m_SchemaSubType) + "\"");
        }
        theBuffer.append(">");
        if (this.m_Value != null) {
            theBuffer.append(VWXMLHandler.toXMLString(this.m_Value));
        }
        theBuffer.append("</fn:ActualParameter>\n");
    }

    public void validate(Vector EDefVector, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationContext validationContext = new VWValidationContext(null, EDefVector);
        this.validate(validationContext, myStep);
    }

    protected void validate(VWValidationContext validationContext, VWCompoundStepDefinition myStep) throws VWException {
        VWValidationError theError;
        VWString theMessage;
        VWValidationError theError2;
        VWString theMessage2;
        if (this.m_Name == null || this.m_Name.length() == 0) {
            theMessage2 = new VWString("vw.api.VWWebServiceparamNullOrEmptyName", "Web service parameter name is null or empty.");
            theError2 = new VWValidationError(3, 1, myStep.getName(), "", theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
            validationContext.addValidationError(theError2);
        }
        if (this.m_Sequence < 0) {
            theMessage2 = new VWString("vw.api.VWWebServiceParamNegativeSequence", "Web service parameter sequence number is less than 0.");
            theError2 = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
            validationContext.addValidationError(theError2);
        }
        if (this.m_LexicalLevel < 0) {
            theMessage2 = new VWString("vw.api.VWWebServiceParamNegativeLexLvl", "Web service parameter lexical level is less than 0.");
            theError2 = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage2.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
            validationContext.addValidationError(theError2);
        }
        VWWebServiceParameterDefinition nextWSP = null;
        try {
            if (this.m_MyInstruction instanceof VWReceiveInstruction) {
                nextWSP = ((VWReceiveInstruction)this.m_MyInstruction).getParameterDefinition(this.m_Sequence + 1);
            } else if (this.m_MyInstruction instanceof VWInvokeInstruction) {
                nextWSP = this.m_Mode == 2 ? ((VWInvokeInstruction)this.m_MyInstruction).getInComingParameterDefinition(this.m_Sequence + 1) : ((VWInvokeInstruction)this.m_MyInstruction).getOutGoingParameterDefinition(this.m_Sequence + 1);
            } else if (this.m_MyInstruction instanceof VWReplyInstruction) {
                nextWSP = ((VWReplyInstruction)this.m_MyInstruction).getParameterDefinition(this.m_Sequence + 1);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!(this.m_LexicalLevel <= 0 || nextWSP != null && nextWSP.getLexicalLevel() == this.m_LexicalLevel + 1 || this.m_Value != null && this.m_Value.compareTo("") != 0)) {
            theMessage = new VWString("vw.api.VWWebServiceParamMustHaveValueExpr", "Web service parameter which are leaf nodes and have a lexical level greater than or equal to 0 must have a value, but value is null or empty for parameter {0}.", this.m_Name);
            theError = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
            validationContext.addValidationError(theError);
        }
        if (this.m_Value != null && this.m_Value.compareTo("") != 0) {
            VWCompiledExpr compRes = null;
            String[] theErrorStrings = null;
            VWWorkflowSignature myWflSignature = myStep.getMap().getWorkflow().getWorkflowSignature(validationContext);
            VWWorkflowSignature myBaseWflSignature = myStep.getMap().getWorkflow().getBaseWorkflowSignature(validationContext);
            if (this.m_Mode == 3 || this.m_Mode == 2) {
                compRes = new VWCompiledRefExpr();
                theErrorStrings = VWExpr.compileVWExpr(":=" + this.m_Value, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            } else {
                compRes = new VWCompiledExpr();
                theErrorStrings = VWExpr.compileVWExpr(this.m_Value, myWflSignature, myBaseWflSignature, null, null, true, compRes);
            }
            if (theErrorStrings != null) {
                int errorCount = theErrorStrings.length;
                for (int i = 0; i < errorCount; ++i) {
                    VWString theMessage3 = new VWString("vw.api.VWWSParameterDefinitionValueSyntaxError", "Parameter {0}, {1}", this.m_Name, theErrorStrings[i]);
                    VWValidationError theError3 = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage3.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
                    validationContext.addValidationError(theError3);
                }
            } else {
                VWValidationError theError4;
                VWString theMessage4;
                if (!VWFieldType.isCompatibleType(this.m_DataType, compRes.getResultType())) {
                    theMessage4 = new VWString("vw.api.VWWSParameterDefinitionIncompatibleExpressionType", "Web Service Parameter definition named \"{0}\" has a value type mismatch,  found {1}, expected {2}", this.m_Name, VWFieldType.typeToString(compRes.getResultType()), VWFieldType.typeToString(this.m_DataType));
                    theError4 = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
                    validationContext.addValidationError(theError4);
                }
                if (this.m_bIsArray != compRes.getResultIsArray()) {
                    theMessage4 = new VWString("vw.api.VWWSParameterDefinitionArrayTypeMismatch", "Parameter {0}, whose value is ({1}), Array v. non-array mismatch", this.m_Name, this.m_Value);
                    theError4 = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage4.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
                    validationContext.addValidationError(theError4);
                }
            }
        }
        if (this.m_SchemaSubType != -1 && this.m_LexicalLevel > 0 && this.m_DataType != -1 && !VWFieldType.isCompatibleType(this.m_DataType, VWXMLSchemaSubType.getVWFieldTypeForSchemaSubType(this.m_SchemaSubType))) {
            theMessage = new VWString("vw.api.VWWebServiceparamIncorrectSchemaSubType", "Web service parameter has a schema sub type, {0}, which is not correct for the data type, {1}, of this parameter.", VWXMLSchemaSubType.typeToString(this.m_SchemaSubType), VWFieldType.typeToString(this.m_DataType));
            theError = new VWValidationError(3, 1, myStep.getName(), this.m_Name, theMessage.toString(), myStep.getMap().getName(), myStep.getStepId(), this.getInstruction().getInstructionId());
            validationContext.addValidationError(theError);
        }
    }

    protected VWInstructionDefinition getInstruction() throws VWException {
        return this.m_MyInstruction;
    }

    protected boolean isIdenticalExceptForValue(VWWebServiceParameterDefinition theComp) throws VWException {
        if (theComp == null) {
            return false;
        }
        return (this.m_ArrayAttributes == null && theComp.m_ArrayAttributes == null || this.m_ArrayAttributes != null && this.m_ArrayAttributes.equals(theComp.m_ArrayAttributes)) && (this.m_ArrayNameSpace == null && theComp.m_ArrayNameSpace == null || this.m_ArrayNameSpace != null && this.m_ArrayNameSpace.equals(theComp.m_ArrayNameSpace)) && (this.m_ArrayTag == null && theComp.m_ArrayTag == null || this.m_ArrayTag != null && this.m_ArrayTag.equals(theComp.m_ArrayTag)) && (this.m_Attributes == null && theComp.m_Attributes == null || this.m_Attributes != null && this.m_Attributes.equals(theComp.m_Attributes)) && this.m_bAttachmentByValue == theComp.m_bAttachmentByValue && this.m_bIsArray == theComp.m_bIsArray && this.m_DataType == theComp.m_DataType && this.m_LexicalLevel == theComp.m_LexicalLevel && this.m_Mode == theComp.m_Mode && (this.m_Name == null && theComp.m_Name == null || this.m_Name != null && this.m_Name.equals(theComp.m_Name)) && (this.m_NameSpace == null && theComp.m_NameSpace == null || this.m_NameSpace != null && this.m_NameSpace.equals(theComp.m_NameSpace)) && this.m_SchemaSubType == theComp.getSchemaSubType();
    }

    public VWSession getSession() throws VWException {
        if (this.m_MyInstruction != null && this.m_MyInstruction.getStep() != null && this.m_MyInstruction.getStep().getMap() != null && this.m_MyInstruction.getStep().getMap().getWorkflow() != null) {
            return this.m_MyInstruction.getStep().getMap().getWorkflow().getSession();
        }
        return null;
    }
}

